import * as Date from 'date-and-time';

export const adskImportToConso = async (dbPool) => {
	return new Promise(async (resolve, reject) => {
		console.log("> Normalisation : asdkImportToConso()");
		// Transfert des données d'import dans la table des consommations en ignorant des données déjà présentes
		let query = `INSERT INTO conso (date, login, produit, version, machine, serveur, durée, emprunt, nbSession, nbToken)
		SELECT adsk_import.date, adsk_import.login, adsk_import.produit, adsk_import.version, adsk_import.machine, adsk_import.serveur, adsk_import.durée, adsk_import.emprunt, adsk_import.nbSession, adsk_import.nbToken
		FROM adsk_import
			WHERE NOT EXISTS (
				SELECT 1 FROM conso
				WHERE conso.date=adsk_import.date AND conso.login=adsk_import.login AND conso.produit=adsk_import.produit AND conso.version=adsk_import.version AND conso.machine=adsk_import.machine AND conso.serveur=adsk_import.serveur AND conso.emprunt=adsk_import.emprunt
			)`;
		try {
			await dbPool.executeQuery(query)
			resolve(true)
		} catch (err) {
			reject(err)
		}
	})
}

export const olmImportToConso = async (dbPool) => {
	return new Promise(async (resolve, reject) => {
		// Conversion des couples Vendor/Feature en Produits(Software)
		console.log("> Normalisation : olmImportToConso()");
		const reqProduits = `UPDATE olm_import AS import
									JOIN olm_feature AS ref
										ON import.Vendor = ref.Vendor AND import.Feature = ref.Feature
									SET import.produit = ref.Software
									WHERE import.produit IS NULL;`;
		await dbPool.executeQuery(reqProduits);

		// Recherche des Features non identifiées
		const featureUndefined = await dbPool.executeQuery("SELECT UNIQUE Feature, Vendor FROM olm_import WHERE ISNULL(produit)");
		if(featureUndefined.length>0) {
			const features = featureUndefined.map(obj => obj.Feature).join(", ");
			return reject(`!!! Le fichier contient une ou des 'Feature' inconnues [${features}]`);
		}

		// Vidage de la table tampon
		await dbPool.executeQuery("TRUNCATE TABLE tampon");

		// Collecte des Login/Machine/Produit (consumers)
		const consumers = await dbPool.executeQuery("SELECT UNIQUE login, machine, serveur, produit, emprunt FROM olm_import");
		// Parcours des utilisations pour chacune de ces 'Consumers"
		for(let csIndex=0; csIndex<consumers.length; csIndex++) {
			const consumer = consumers[csIndex];
			const conso = {date:"", login:consumer.login, machine:consumer.machine, produit:consumer.produit, serveur:consumer.serveur, emprunt:consumer.emprunt, durée:0, nbSession:0, heureDébut:"", heureFin:""};
			// Chargement des usages pour cette source
			const usages = await dbPool.executeQuery(`SELECT * FROM olm_import WHERE login='${consumer.login}' AND machine='${consumer.machine}' AND produit='${consumer.produit}' AND emprunt=${consumer.emprunt} ORDER BY StartTime`)
			// Parcours des usages
			for(let index=0; index<usages.length; index++) {
				const usage = usages[index];
				var usageStart	= usage.StartTime;
				var usageEnd	= usage.EndTime;
				//console.log("------------------------------------\n - usage:", usage);
				if(conso.date=="") {
					//console.log(" - Init conso");
					// Initialisation de la conso
					conso.date			= Date.format(usageStart, "YYYY-MM-DD");
					conso.durée			= 0;
					conso.nbSession	= 0;
					conso.heureDébut	= usageStart;
					conso.heureFin		= usageEnd;
				} else {
					// Même jour ?
					if(Date.isSameDay(conso.heureDébut, usageStart)) {
						//console.log(" - Même jour");
						if(usageStart<conso.heureFin) {
							//console.log(" - Même session : usage commençant avant la fin de la conso en cours");
							if(usageEnd>conso.heureFin) {
								//console.log(" ... Cet usage étend la conso en cours > Report de l'heure de fin de la conso");
								conso.heureFin = usageEnd;
							} //else console.log(" ... usage inclus dans la conso en cours");
						} else {
							// Calcul du temps écoulé entre la fin du dernier usage et l'usage en cours
							var duration = Date.subtract(conso.heureFin, usageStart);
							if(duration.toMinutes().value<5) {
								// Moins de 5mn > même session
								//console.log(" - Même session : moins de 5mn depuis la fin de la précédante session");
								//console.log(" ... Report de l'heure de fin");
								conso.heureFin = usageEnd;
							} else {
								//console.log(" - Nouvelle session : plus de 5mn depuis la fin de la précédante session");
								// Nouvelle session
								var duration	= Date.subtract(conso.heureDébut, conso.heureFin);	// Calcul durée de session
								conso.durée 	+= duration.toHours().value;
								conso.nbSession++;
								conso.heureDébut	= usageStart;
								conso.heureFin		= usageEnd;
							}
						}
					} else {		// Changement de jour
						//console.log(" - Changement de jour");
						// Clôture de la conso précédante
						var duration = Date.subtract(conso.heureDébut, conso.heureFin);	// Calcul durée de session
						conso.durée 	+= duration.toHours().value;
						conso.nbSession++;
						// Enregistrer la conso
						await dbPool.insertData("tampon", {date:conso.date, login:conso.login, machine:conso.machine, serveur:conso.serveur, produit:conso.produit, emprunt:conso.emprunt, nbSession:conso.nbSession, durée:conso.durée, source:"OpenLM"});
						//console.log(">>> Enregistrement conso:", conso);
						// Initialisation nouvelle conso
						conso.date			= Date.format(usageStart, "YYYY-MM-DD");
						conso.durée			= 0;
						conso.nbSession	= 0;
						conso.heureDébut	= usageStart;
						conso.heureFin		= usageEnd;						
					}
				}
				while(!Date.isSameDay(usageStart, usageEnd)) {
					//console.log(" ! Utilisation sur plus d'un jour");
					// Usage sur plus d'un jour
					conso.heureFin = Date.parse(conso.date+" 23:59:59.999", "YYYY-MM-DD HH:mm:ss.SSS");
					var duration	= Date.subtract(conso.heureDébut, conso.heureFin);
					conso.durée 	+= duration.toHours().value;
					conso.nbSession++;
					// Enregistrer la conso
					await dbPool.insertData("tampon", {date:conso.date, login:conso.login, machine:conso.machine, serveur:conso.serveur, produit:conso.produit, emprunt:conso.emprunt, nbSession:conso.nbSession, durée:conso.durée, source:"OpenLM"});
					//console.log(">>> Enregistrement conso:", conso);
					// Initialiser la conso sur le nouveau jour
					usageStart			= Date.addDays(Date.parse(conso.date+ " 00:00:00", "YYYY-MM-DD HH:mm:ss.SSS"), 1)
					conso.date			= Date.format(usageStart, "YYYY-MM-DD");
					conso.durée			= 0;
					conso.nbSession	= 0;
					conso.heureDébut	= usageStart;
					conso.heureFin		= usageEnd;
				}
			}
			// Bouclage dernière conso
			var duration	= Date.subtract(conso.heureDébut,usageEnd);
			conso.durée 	+= duration.toHours().value;
			conso.nbSession++;
			// Enregistrer la conso
			await dbPool.insertData("tampon", {date:conso.date, login:conso.login, machine:conso.machine, serveur:conso.serveur, produit:conso.produit, emprunt:conso.emprunt, nbSession:conso.nbSession, durée:conso.durée, source:"OpenLM"});
			//console.log(">>> Enregistrement conso:", conso);
		};
		
		//console.log("FIN D'IMPORT");
		// Transfert des données d'import dans la table des consommations en ignorant des données déjà présentes
		let query = `INSERT INTO conso (date, login, produit, machine, serveur, durée, emprunt, nbSession, source)
		SELECT tampon.date, tampon.login, tampon.produit, tampon.machine, tampon.serveur, tampon.durée, tampon.emprunt, tampon.nbSession, tampon.source
		FROM tampon
			WHERE NOT EXISTS (
				SELECT 1 FROM conso
				WHERE conso.date=tampon.date AND conso.login=tampon.login AND conso.produit=tampon.produit AND conso.machine=tampon.machine AND conso.serveur=tampon.serveur AND conso.emprunt=tampon.emprunt
			)`;
		try {
			await dbPool.executeQuery(query);
			resolve(true)
		} catch (err) {
			reject(err)
		}
	});
}