/*=========================================================
	MODULE zPoolMariaDB
	----------------------------------------------------
	Classe Pool Connector
		Création d'un pool MariaDB et gestion des connexion
		et requêtes
	V1.0 :
=========================================================*/
import mariadb from 'mariadb';

export class PoolMariaDB {
	
	constructor(dbConfig) {
		this.pool = mariadb.createPool({
			host: dbConfig.host,
			port: dbConfig.port || 3306,
			user: dbConfig.user, 
			password: dbConfig.password,
			database: dbConfig.database,
			connectionLimit: dbConfig.cnxMax,
			decimalAsNumber: true
		});
		this.database = dbConfig.database;
	}

	async executeQuery(query, params=[]) {
		return new Promise(async (resolve, reject) => {
			// Connexion au pool		
			const cnx = await this.pool.getConnection();
			// Exécution de la requête
			cnx.query(query, params)
			.then(result => { 
				//console.log(result);
				resolve(result) })
			.catch(err => { reject(err) })
			.finally(cnx.release());
		})
	}

	async insertData(table, data) {
		return new Promise(async (resolve, reject) => {
			// Connexion au pool		
			const cnx = await this.pool.getConnection();
			// Création des tables champs et valeurs
			const champs = Object.keys(data).join(', ');
			const valeurs = Object.values(data).map(val => cnx.escape(val)).join(', ');
			// Construction de la requête
			const query = `INSERT INTO ${table} (${champs}) VALUES (${valeurs})`;
			// Exécution de la requête
			cnx.query(query)
			.then(result => { 
				//console.log(result);
				resolve(result) })
			.catch(err => { reject(err) })
			.finally(cnx.release());
		})
	}

	async updateData(table, data, filter) {
		return new Promise(async (resolve, reject) => {
			// Connexion au pool		
			const cnx = await this.pool.getConnection();
			// Création de l'ensemble des tuples à modifier
			const setValues = Object.entries(data).map(([key, value]) => { return `${key}='${value}'`} ).join(", ");
			// Création de la requête
			const query = `UPDATE ${table} SET ${setValues} WHERE ${filter}`
			// Exécution e la requête
			cnx.query(query)
			.then(result => { 
				//console.log(result);
				resolve(result) })
			.catch(err => { reject(err) })
			.finally(cnx.release());
		})
	}

	async getTables() {
		return new Promise(async (resolve, reject) => {
			const cnx = await this.pool.getConnection();
			// Exécution de la requête
			const query = `SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '${this.database}'`;
			// Connexion au pool		
			cnx.query(query)
			.then(result => { 
				const tableList = result.map(obj => obj.TABLE_NAME);
				resolve(tableList); })
			.catch(err => { reject(err); })
			.finally(cnx.release());
		})
	}

	async getStream(query) {
		return new Promise(async (resolve, reject) => {
			const cnx = await this.pool.getConnection();
			try {
				// Exécution de la requête
				const stream = cnx.queryStream(query);
				resolve(stream);
			} catch (err) {
				reject(err);
			}
		})
	}

	async close() {
		await this.pool.end();
		this.pool = undefined;
	}
}

