// TaskQueue.mjs
export class TaskManager {
  constructor() {
    this.tasks = [];      // file d'attente des fonctions
    this.running = false; // indique si une tâche est en cours
  }

  // Ajoute une tâche à la file et démarre l'exécution si nécessaire
  pushTask(taskFn) {
    if (typeof taskFn !== 'function') {
      throw new TypeError('La tâche doit être une fonction');
    }
    console.log("Ajout d'une tâche");

    this.tasks.push(taskFn);
    this._process(); // tente de démarrer l’exécution
  }

  // Processus principal : exécute les tâches une par une
  async _process() {
    if (this.running || this.tasks.length === 0) return;

    this.running = true;

    while (this.tasks.length > 0) {
      const task = this.tasks.shift();

      try {
        console.log("Lancement d'une tâche");
        await task(); // exécute la tâche
      } catch (err) {
        console.error('Erreur dans une tâche :', err);
      }
    }

    this.running = false;
  }

  // Optionnel : permet de vider la pile
  clear() {
    this.tasks = [];
  }
}
