/** @preserve Copyright (c) KNOWLEDGECODE - MIT License */
type CompiledObject = string[];

interface LocaleOptions {
    compiledObj: CompiledObject;
    style: 'long' | 'short' | 'narrow';
    case?: 'uppercase' | 'lowercase';
}
interface Locale {
    getLocale: () => string;
    getMonthList: (options: LocaleOptions) => string[];
    getDayOfWeekList: (options: LocaleOptions) => string[];
    getMeridiemList: (options: LocaleOptions) => string[];
}

interface Numeral {
    encode: (str: string) => string;
    decode: (str: string) => string;
}

interface TimeZone {
    zone_name: string;
    gmt_offset: number[];
}

type ParserToken = 'Y' | 'M' | 'D' | 'H' | 'A' | 'h' | 'm' | 's' | 'S' | 'Z';
interface ParserPluginOptions {
    /**
     * The hour format to use for parsing.
     * This is used when the hour is in 12-hour format.
     * It can be 'h11' for 11-hour format or 'h12' for 12-hour format.
     */
    hour12: 'h11' | 'h12';
    /**
     * The hour format to use for parsing.
     * This is used when the hour is in 24-hour format.
     * It can be 'h23' for 23-hour format or 'h24' for 24-hour format.
     */
    hour24: 'h23' | 'h24';
    /**
     * The numeral system to use for parsing numbers.
     * This is an object that provides methods to encode and decode numbers in the specified numeral system.
     */
    numeral: Numeral;
    /**
     * The calendar system to use for parsing dates.
     * This can be 'buddhist' for Buddhist calendar or 'gregory' for Gregorian calendar.
     */
    calendar: 'buddhist' | 'gregory';
    /**
     * Whether to ignore case when matching strings.
     * This is useful for matching month names, day names, and meridiems in a case-insensitive manner.
     * If true, the parser will convert both the input string and the strings in the locale to lowercase before matching.
     */
    ignoreCase: boolean;
    /**
     * The time zone to use for parsing dates and times.
     * This can be a specific time zone object or 'UTC' to use Coordinated Universal Time.
     * If not specified, it defaults to undefined, which means the local time zone will be used.
     */
    timeZone: TimeZone | 'UTC' | undefined;
    /**
     * The locale to use for parsing dates and times.
     * This is an object that provides methods to get localized month names, day names, and meridiems.
     */
    locale: Locale;
}
interface ParseResult {
    value: number;
    length: number;
    token?: ParserToken;
}
declare abstract class ParserPlugin {
    [key: string]: (str: string, options: ParserPluginOptions, compiledObj: CompiledObject) => ParseResult;
}

declare class Parser extends ParserPlugin {
    SSSS(str: string): {
        value: number;
        length: number;
        token: ("Y" | "M" | "D" | "H" | "A" | "h" | "m" | "s" | "S" | "Z") | undefined;
    };
    SSSSS(str: string): {
        value: number;
        length: number;
        token: ("Y" | "M" | "D" | "H" | "A" | "h" | "m" | "s" | "S" | "Z") | undefined;
    };
    SSSSSS(str: string): {
        value: number;
        length: number;
        token: ("Y" | "M" | "D" | "H" | "A" | "h" | "m" | "s" | "S" | "Z") | undefined;
    };
    f(str: string): {
        value: number;
        length: number;
        token: ("Y" | "M" | "D" | "H" | "A" | "h" | "m" | "s" | "S" | "Z") | undefined;
    };
    ff(str: string): {
        value: number;
        length: number;
        token: ("Y" | "M" | "D" | "H" | "A" | "h" | "m" | "s" | "S" | "Z") | undefined;
    };
    fff(str: string): {
        value: number;
        length: number;
        token: ("Y" | "M" | "D" | "H" | "A" | "h" | "m" | "s" | "S" | "Z") | undefined;
    };
}
declare const parser: Parser;

export { parser };
