const wsURL = 'ws://genre-huguenot.hd.free.fr:8000'
//const wsURL = 'ws://192.168.1.50:8000'
//const wsURL = 'ws://localhost:8000';
// Variable de stockage de l'objet WebSocket
var ws
// Accès aux fonctions contenue dans le iFrame
const iframe = document.getElementById('mainFrame');
const iframeContent = document.getElementById('mainFrame').contentWindow;


function connectWithTimeout(url, timeout) {
	console.log(`Demande de connexion à ${URL}`);
	return new Promise((resolve, reject) => {
		ws = new WebSocket(url);
		let didTimeOut = false;
 
		// Timer pour le timeout
		const timer = setTimeout(() => {
			didTimeOut = true;
			ws.close();
			reject(new Error('Connexion au WebSocketServer expirée'));
		}, timeout);
 
		// Événement déclenché lorsque la connexion est ouverte
		ws.onopen = () => {
			if (!didTimeOut) {
				clearTimeout(timer);
				//updNodeState('on');
				resolve(ws); // Connexion réussie
			}
		};
 
		// Événement déclenché en cas d'erreur
		ws.onerror = (error) => {
			if (!didTimeOut) {
				clearTimeout(timer);
				reject(new Error('Erreur lors de la connexion au WebSocketServer'));
			}
		};
 
		// Événement déclenché lorsque la connexion est fermée
		ws.onclose = (event) => {
			//updNodeState('off');
			if (didTimeOut) {
				return; // Ignorez si c'est causé par le timeout
			}
			if (event.wasClean) {
				resolve(ws); // Connexion fermée proprement
			} else {
				reject(new Error('Connexion au WebSocketServer fermée avec une erreur'));
			}
		};
	});
}

function nodeSend(from, notification, data=null) {
	if(!ws) {
		console.error("!!! le webService n'est pas en ligne");
		return
	}
	var message = {};
	message['from'] = from;
	message['notif'] = notification;
	if(data) message['data'] = data;
	ws.send(JSON.stringify(message));
}

function updNodeState(state) {
	elm = document.getElementById('nodeStatus');
	if(elm){
		switch(state.toLowerCase()) {
			case "on":
				elm.textContent='EN LIGNE';
				elm.classList.add("on");
				elm.classList.remove("off");
				elm.classList.remove("unknown");
				break;
			case "off":
				elm.textContent='HORS LIGNE';
				elm.classList.add("off");
				elm.classList.remove("on");
				elm.classList.remove("unknown");
				break;
			default:
				elm.textContent='INCONNU';
				elm.classList.add("unknown");
				elm.classList.remove("on");
				elm.classList.remove("off");
		}
	}
}

// Test si une chaine est interprétable en tant que JSON
function isJsonString(str) {
	try {
		JSON.parse(str);
	} catch (e) {
		return false;
	}
	return true;
}

function connectWebService(URL) {
	connectWithTimeout(URL, 2000)
	.then(socket => {
		console.log('Connexion au WebSocketServer réussie');
		socket.onmessage = (event) => {
			iframe.contentWindow.messageProcessing(event);
		}
	})
	.catch(error => {
		console.error('Erreur:', error.message);
		startNode();
	});
}

function startNode() {
	console.log(`Demande d'exécution du WebServiceServer`);
	
	const formData = new FormData();
	formData.append('script', 'node_ws');

	fetch('./php/_nodeLaunch.php', {
		method: 'POST',
		body: formData
	})
	.then(response => {
		if(!response.ok) {
			throw new Error();
		}
		setTimeout(connectWebService(wsURL), 2000);
		return response.text();	
	})
	.then(data => {
		console.log(data);
	})
	.catch(error => {
		console.error(error);
	});
}

connectWebService(wsURL);
