<?php

// Include des fonctions PHP communes
include_once "_common.php";

// Lecture des tables
$paramFile = "$projectRoot/php/secure/tables.xml";
if (file_exists($paramFile)) {
	trace("> Chargement des paramètres des tables depuis le fichier XML");
	$tables = simplexml_load_file($paramFile);
} else {
	trace('!!! Fichier de paramètres absent.');
}

function buildDataTable($view, $request="") {
	global $tables, $dataBase;

	// Vérification de l'exitence des paramètres
	$xmlQuery = $tables->xpath("//table[@nom='$view']");
	if($xmlQuery) {$table = $xmlQuery[0];} else {return false;}
	//echo "Table ".$table['cle'].'<br>';

	// Génération de l'entête
	echo "	<thead>".PHP_EOL;
	echo "		<tr>".PHP_EOL;
	foreach($table->col as $column) {
		$insert  = '<th id="th_'.$column['champ'].'"';
		$insert .= ' class="td_'.$column['champ'].' unselectable';
		if($column['sort']=="true") {$insert .= ' tsort';}
		$insert .= '"';
		$insert .= ' data-field="'.$column['champ'].'"';
		$insert .= ' data-align="'.$column['align'].'"';
		$insert .= '>'.$column[0].'</th>';
		echo "			$insert".PHP_EOL;
	}
	echo '			<th></th>'.PHP_EOL;
	echo "		</tr>".PHP_EOL;
	echo "	</thead>".PHP_EOL;
	// Génération du corps
	echo "	<tbody>".PHP_EOL;
	if($request) {
		// Lecture des données
		$records = ExecuteRequete($request, $dataBase);
		// Remplissage de la table
		foreach($records as $record) {
			//echo '		<tr class="selectable alternateColor" ondblclick="tableEdit(this)">'.PHP_EOL;
			echo '		<tr class="alternateColor" data-key="'.$record[(string)$table['cle']].'">'.PHP_EOL;
			foreach($table->col as $column) {
				$insert  = '<td';
				if($column['align']=="center") {$insert .= ' class="tdCenter"';}
				$insert .= ' data-field="'.$column['champ'].'"';
				$insert .= '>'.$record[(string)$column['champ']].'</td>';
				echo "			$insert".PHP_EOL;
			}
			echo '			<td class="blankFill"></td>'.PHP_EOL;
			echo "		</tr>".PHP_EOL;
		}
	}
	echo "	</tbody>".PHP_EOL;
}

// Exécution en mode test client
if(CLI) {buildDataTable("joueurs");}