<?php

function entryField(string $name, string $type="text", string $label="", bool $row=true, string $value="", array $lbl_class=[], array $inp_class=[], bool $readonly=false) {
	if ($row) {
		$HTML  = '<div class="zFlexRow zVCenter zMgB">'.PHP_EOL;
	} else {
		$HTML  = '<div class="zFlexCol">'.PHP_EOL;
	}
	$HTML .= '	<label for="'.$name.'"';
	if($lbl_class) {$HTML .= ' class="zLabelStyle '.implode(" ", $lbl_class);}
	$HTML .= '">'.$label.'</label>'.PHP_EOL;
	$HTML .= '	<input type="text" id="'.$name.'"';
	if($inp_class) {$HTML .= ' class="zInputField '.implode(" ", $inp_class).'"';}
	if($readonly) {$HTML .= ' readonly';}
	$HTML .= '>'.PHP_EOL;
	$HTML .= '</div>'.PHP_EOL;
	echo $HTML;
}

function buttonField(string $name, string $label, string $onclick, string $icon="", array $btn_class=[], array $img_class=[]) {
	$HTML  = '<button type="button"';
	if($btn_class) {$HTML .= ' class="'.implode(" ", $btn_class).'"'; } else {$HTML .= ' class="zButton"';}
	$HTML .= ' onclick="'.$onclick.'()">';
	if($icon) {
		$HTML .= '<img';
		if($img_class) {$HTML .= ' class="'.implode(" ", $img_class).'"';} else {$HTML .= ' class="zIconzButtonImageLeft"';}
		$HTML .= ' src="../images/'.$icon.'" alt=""></img>';
	}
	if($label) {$HTML .= html_entity_decode($label);}
	$HTML .= '</button>'.PHP_EOL;
	echo $HTML;
} 

function imageButtonField(string $onclick, string $icon="", array $class=[]) {
	$HTML = '<img class="zButtonImage zMgB" src="../images/'.$icon.'" alt="" onclick="'.$onclick.'()"></img>'.PHP_EOL;
	echo $HTML;
} 

function entryBlank(bool $row=true, array $class=[]) {
	if ($row) {
		$HTML  = '<div class="zFlexRow zMgB'.PHP_EOL;
	} else {
		$HTML  = '<div class="zFlexCol'.PHP_EOL;
	}
	if($class) {$HTML .= implode(" ", $class).'">';}
	$HTML .= '</div>'.PHP_EOL;
	echo $HTML;
}
