import * as zLib from "./modules/zJsLibrary.js";
import { Theme } from "./modules/zJsTheme.js";
import { MessageBar } from "./modules/zJsMessageBar.js";
import { subscribeSocketStatus, subscribeTo } from "./modules/zJsWebSocketClient.js";

console.clear();
var scriptURL = new URL(import.meta.url);
console.log(`Chargement module JavaScript : ${scriptURL.pathname}`);
const alea = Math.random();

const appName = "Splendor";
const WIP = document.getElementById('wip');

/*=========================================================
           GESTION PALLETTES COULEURS ET STYLES
=========================================================*/
const zJsTheme = {
	colors: [{id:"light", css:"_schemeLight.css"}, {id:"dark", css:"_schemeDark.css"}],
	styles: [{id:"default", css:"_variablesDefault.css"}, {id:"A", css:"_variablesStyleA.css"}]
}
const myTheme = new Theme(zJsTheme);
// Positionnement du themeCheckbox
const themeCheckbox = document.getElementById('theme-checkbox');
if(themeCheckbox) {
	themeCheckbox.addEventListener('click', () =>{
		myTheme.toogleColor(["light", "dark"]);
	});
	if(myTheme.colorId==zJsTheme.colors[0].id) {
		themeCheckbox.setAttribute('checked', true);
	} else {
		themeCheckbox.removeAttribute('checked');
	}
}

/*=========================================================
				GESTION DES MESSAGES PIED DE PAGE
=========================================================*/
const messageBar = new MessageBar("fmessage", "WEBGAMES | Splendor Duel - janvier 2026 - Powered by zTechnology");
// Propagation de l'objet à la fenêtre du navigateur
window.messageBar = messageBar;
// Souscription aux messages "info" (bandeau info)
subscribeTo("INFO", (data) => { messageBar.push({msg:data, type:'info', priority:5}); });

// Souscription aux changement d'état de la connexion WebSocket
subscribeSocketStatus((status) => { document.getElementById("webAPI").classList = "state "+status });

// Gestion des actions sur la page lors de son ouverture
window.onload = () => {
	// Mémorisation de la page en cours pour la gestion du iFrame "index.html"
	var urlPage = window.location.pathname;
	const splitUrl = urlPage.split("/");
	const nomPage = splitUrl[splitUrl.length-1]
	sessionStorage.setItem(appName, nomPage);
}

window.navPage = (page) => {
	const root = location.href.substring(0, location.href.lastIndexOf("/"))+"/";
	const url = new URL(root+page);
	document.location.href=url;
}
