/*=========================================================
	MODULE zJsLibrary
	----------------------------------------------------
	Bibliothèque de gestion du thème graphique (couleur et style)
=========================================================*/

export class Theme {
	constructor(objTheme) {
		//console.log("Build theme from:", objTheme);
		this.theme = objTheme;
		if(objTheme.colors) {
			const colorId = (localStorage.getItem("themeColor"))? localStorage.getItem("themeColor") : objTheme.colors[0].id;
			this.changeColor(colorId);
		}
		if(objTheme.styles) {
			const styleId = (localStorage.getItem("themeStyle"))? localStorage.getItem("themeStyle") : objTheme.styles[0].id;
			this.changeStyle(styleId);
		}
	}

	changeColor(colorId) {
		//console.log("Change/Set color to:", colorId);
		// Lecture du Mode stocké dans le Storage Local
		if(this.theme.colors.find(obj => obj.id==colorId)) {
			if(localStorage.getItem("themeColor")) this.#removeCssFile(`../styles/${this.theme.colors.find(obj => obj.id==localStorage.getItem("themeColor")).css}`);	// Supression de la palette actuelle
			localStorage.setItem("themeColor", colorId);	// Enregistrement du nouveau mode
			this.#loadCssFile(`../styles/${this.theme.colors.find(obj => obj.id==colorId).css}`);											// Chargement du nouveau mode
			this.colorId = colorId;
		}
	}

	changeStyle(styleId) {
		//console.log("Change/Set style to:", styleId);
		// Lecture du Mode stocké dans le Storage Local
		if(this.theme.styles.find(obj => obj.id==styleId)) {
			if(localStorage.getItem("themeStyle")) this.#removeCssFile(`../styles/${this.theme.styles.find(obj => obj.id==localStorage.getItem("themeStyle")).css}`);	// Supression de la palette actuelle
			localStorage.setItem("themeStyle", styleId);	// Enregistrement du nouveau mode
			this.#loadCssFile(`../styles/${this.theme.styles.find(obj => obj.id==styleId).css}`);											// Chargement du nouveau mode
			this.styleId = styleId;
		}
	}

	toogleColor(colors) {
		//console.log("Switch between colors:", colors);
		const actualColor = colors.indexOf(this.colorId);
		if(actualColor>-1) {
			const newColorId = (actualColor==0)? colors[1] : colors[0];
			this.changeColor(newColorId);
		}
		else console.error("La couleur actuelle n'est pas dans les couleurs proposées");
	}

	#loadCssFile(fileName) {
		// Chargement dynamique d'un fichier CSS
		const elmLink = document.createElement("link");
		elmLink.setAttribute("rel", "stylesheet");
		elmLink.setAttribute("type","text/css");
		elmLink.setAttribute("href",fileName);
		document.getElementsByTagName("head")[0].appendChild(elmLink);
	}

	#removeCssFile(fileName) {
		// Suppression dynamique d'un fichier CSS
		const elmLink = document.querySelector(`link[href="${fileName}"]`);
		if(elmLink) elmLink.parentNode.removeChild(elmLink);
	}
}
