import { WSServer } from './modules/zNodeWebSocketServer.mjs';
// ---------------------------------------------------------------------
import config from './data/webAPI.json' with { type: "json" };					// Paramètres contenu dans le fichier webAPI.json
import dbConfig from './data/db.json' with { type: "json" };					// Paramètres de connexion à la DB

// Création du WebServer 
const ws = new WSServer({
	port: config.webService.port,
	onMessage: ({ clientId, message }) => {
		console.log(`📨 Message de ${clientId}:`, message);
		//console.log(`📨 Message de ${clientId}`);
		messageProcessing(clientId, message);
	}
});

/*=============================================
		TRAITEMENT DES MESSAGES ENTRANTS
	=============================================*/
async function messageProcessing(clientId, message) {
	//console.log("> Réception message:", message);
	if(message.type) {
		switch(message.type.toUpperCase()) {
			case "LOGIN":
				break;
			case "REQUEST TO PLAY":
				break;
			case "REQUEST DENIED":
				break;
			case "REQUEST ACCEPTED":
				break;
			case "IN GAME":
				break;
			case "UPDATE":
				break;
			case "REFRESH":
				break;
			case "CHAT":
				break;
			default:
				console.error(`‼️Type message inconnu [${message.type}]`);
		}
	} else console.error("‼️Absence de 'type' dans le message\n", message);

}
