-- --------------------------------------------------------
-- Hôte:                         127.0.0.1
-- Version du serveur:           11.1.1-MariaDB - mariadb.org binary distribution
-- SE du serveur:                Win64
-- HeidiSQL Version:             12.3.0.6589
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Listage de la structure de table splendor. card
DROP TABLE IF EXISTS `card`;
CREATE TABLE IF NOT EXISTS `card` (
  `id` tinyint(3) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `initColor` varchar(10) DEFAULT NULL,
  `value` tinyint(3) unsigned DEFAULT NULL,
  `prestige` tinyint(3) unsigned DEFAULT NULL,
  `crown` tinyint(3) unsigned DEFAULT NULL,
  `power` varchar(10) DEFAULT NULL,
  `whiteCost` tinyint(3) unsigned DEFAULT NULL,
  `blueCost` tinyint(3) unsigned DEFAULT NULL,
  `greenCost` tinyint(3) unsigned DEFAULT NULL,
  `redCost` tinyint(3) unsigned DEFAULT NULL,
  `blackCost` tinyint(3) unsigned DEFAULT NULL,
  `pearlCost` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `niveau` (`level`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Listage des données de la table splendor.card : ~71 rows (environ)
INSERT INTO `card` (`id`, `level`, `initColor`, `value`, `prestige`, `crown`, `power`, `whiteCost`, `blueCost`, `greenCost`, `redCost`, `blackCost`, `pearlCost`) VALUES
	(1, 1, '', 1, 0, 1, '', 4, 0, 0, 0, 0, 1),
	(2, 1, '', 1, 1, 0, '', 0, 2, 0, 2, 1, 1),
	(3, 1, '', 1, 1, 0, '', 0, 0, 0, 0, 4, 1),
	(4, 1, '', 1, 1, 0, '', 2, 0, 2, 0, 1, 1),
	(5, 1, 'neutral', 0, 3, 0, '', 0, 0, 0, 4, 0, 1),
	(6, 1, 'white', 1, 0, 1, '', 0, 3, 0, 0, 0, 0),
	(7, 1, 'white', 1, 0, 0, 'gem', 0, 0, 0, 2, 2, 0),
	(8, 1, 'white', 1, 0, 0, 'play', 0, 2, 2, 0, 0, 1),
	(9, 1, 'white', 1, 1, 0, '', 0, 0, 2, 3, 0, 0),
	(10, 1, 'white', 1, 0, 0, '', 0, 1, 1, 1, 1, 0),
	(11, 1, 'blue', 1, 0, 1, '', 0, 0, 3, 0, 0, 0),
	(12, 1, 'blue', 1, 0, 0, 'gem', 2, 0, 0, 0, 2, 0),
	(13, 1, 'blue', 1, 0, 0, 'play', 0, 0, 2, 2, 0, 1),
	(14, 1, 'blue', 1, 1, 0, '', 0, 0, 0, 2, 3, 0),
	(15, 1, 'blue', 1, 0, 0, '', 1, 0, 1, 1, 1, 0),
	(16, 1, 'black', 1, 0, 1, '', 3, 0, 0, 0, 0, 0),
	(17, 1, 'black', 1, 0, 0, 'gem', 0, 0, 2, 2, 0, 0),
	(18, 1, 'black', 1, 0, 0, 'play', 2, 2, 0, 0, 0, 1),
	(19, 1, 'black', 1, 1, 0, '', 0, 2, 3, 0, 0, 0),
	(20, 1, 'black', 1, 0, 0, '', 1, 1, 1, 1, 0, 0),
	(21, 1, 'red', 1, 0, 1, '', 0, 0, 0, 0, 3, 0),
	(22, 1, 'red', 1, 0, 0, 'gem', 0, 2, 2, 0, 0, 0),
	(23, 1, 'red', 1, 0, 0, 'play', 2, 0, 0, 0, 2, 1),
	(24, 1, 'red', 1, 1, 0, '', 2, 3, 0, 0, 0, 0),
	(25, 1, 'red', 1, 0, 0, '', 1, 1, 1, 0, 1, 0),
	(26, 1, 'green', 1, 0, 1, '', 0, 0, 0, 3, 0, 0),
	(27, 1, 'green', 1, 0, 0, 'gem', 2, 2, 0, 0, 0, 0),
	(28, 1, 'green', 1, 0, 0, 'play', 0, 0, 0, 2, 2, 1),
	(29, 1, 'green', 1, 1, 0, '', 3, 0, 0, 0, 2, 0),
	(30, 1, 'green', 1, 0, 0, '', 1, 1, 0, 1, 1, 0),
	(40, 2, '', 1, 0, 2, '', 0, 0, 6, 0, 0, 1),
	(41, 2, '', 1, 0, 2, '', 0, 6, 0, 0, 0, 1),
	(42, 2, '', 1, 2, 0, '', 0, 0, 6, 0, 0, 1),
	(43, 2, 'neutral', 0, 5, 0, '', 0, 6, 0, 0, 0, 1),
	(44, 2, 'white', 1, 2, 1, '', 0, 0, 2, 2, 2, 1),
	(45, 2, 'white', 1, 2, 0, 'privilege', 4, 0, 0, 0, 2, 1),
	(46, 2, 'white', 1, 1, 0, 'theft', 0, 4, 0, 3, 0, 0),
	(47, 2, 'white', 2, 1, 0, '', 0, 5, 2, 0, 0, 0),
	(48, 2, 'blue', 1, 2, 1, '', 2, 0, 0, 2, 2, 1),
	(49, 2, 'blue', 1, 2, 0, 'privilege', 2, 4, 0, 0, 0, 1),
	(50, 2, 'blue', 1, 1, 0, 'theft', 0, 0, 4, 0, 3, 0),
	(51, 2, 'blue', 2, 1, 0, '', 0, 0, 5, 2, 0, 0),
	(52, 2, 'black', 1, 2, 1, '', 0, 2, 2, 2, 0, 1),
	(53, 2, 'black', 1, 2, 0, 'privilege', 0, 0, 0, 2, 4, 1),
	(54, 2, 'black', 1, 1, 0, 'theft', 4, 0, 3, 0, 0, 0),
	(55, 2, 'black', 2, 1, 0, '', 5, 2, 0, 0, 0, 0),
	(56, 2, 'red', 1, 2, 1, '', 2, 2, 2, 0, 0, 1),
	(57, 2, 'red', 1, 2, 0, 'privilege', 0, 0, 2, 4, 0, 1),
	(58, 2, 'red', 1, 1, 0, 'theft', 0, 3, 0, 0, 4, 0),
	(59, 2, 'red', 2, 1, 0, '', 2, 0, 0, 0, 5, 0),
	(60, 2, 'green', 1, 2, 1, '', 2, 2, 0, 0, 2, 1),
	(61, 2, 'green', 1, 2, 0, 'privilege', 0, 2, 4, 0, 0, 1),
	(62, 2, 'green', 1, 1, 0, 'theft', 3, 0, 0, 4, 0, 0),
	(63, 2, 'green', 2, 1, 0, '', 0, 0, 0, 5, 2, 0),
	(70, 3, '', 1, 0, 3, '', 0, 0, 0, 0, 8, 0),
	(71, 3, '', 1, 3, 0, 'play', 0, 0, 0, 8, 0, 0),
	(72, 3, 'neutral', 0, 6, 0, '', 8, 0, 0, 0, 0, 0),
	(73, 3, 'white', 1, 3, 2, '', 0, 3, 0, 5, 3, 1),
	(74, 3, 'white', 1, 4, 0, '', 6, 2, 0, 0, 2, 0),
	(75, 3, 'blue', 1, 3, 2, '', 3, 0, 3, 0, 5, 1),
	(76, 3, 'blue', 1, 4, 0, '', 2, 6, 2, 0, 0, 0),
	(77, 3, 'black', 1, 3, 2, '', 3, 0, 5, 3, 0, 1),
	(78, 3, 'black', 1, 4, 0, '', 2, 0, 0, 2, 6, 0),
	(79, 3, 'red', 1, 3, 2, '', 0, 5, 3, 0, 3, 1),
	(80, 3, 'red', 1, 4, 0, '', 0, 0, 2, 6, 2, 0),
	(81, 3, 'green', 1, 3, 2, '', 5, 3, 0, 3, 0, 1),
	(82, 3, 'green', 1, 4, 0, '', 0, 2, 6, 2, 0, 0),
	(101, 0, 'neutral', 0, 2, 0, 'play', 0, 0, 0, 0, 0, 0),
	(102, 0, 'neutral', 0, 2, 0, 'privilege', 0, 0, 0, 0, 0, 0),
	(103, 0, 'neutral', 0, 2, 0, 'theft', 0, 0, 0, 0, 0, 0),
	(104, 0, 'neutral', 0, 3, 0, '', 0, 0, 0, 0, 0, 0);

-- Listage de la structure de table splendor. game
DROP TABLE IF EXISTS `game`;
CREATE TABLE IF NOT EXISTS `game` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `dateTime` timestamp NULL DEFAULT NULL,
  `playerA_ID` int(11) unsigned DEFAULT NULL,
  `playerB_ID` int(11) unsigned DEFAULT NULL,
  `playerTurn` varchar(1) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `round` int(10) unsigned DEFAULT NULL,
  `step` varchar(3) DEFAULT NULL,
  `winnerID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `joueurA` (`playerA_ID`) USING BTREE,
  KEY `joueurB` (`playerB_ID`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Listage des données de la table splendor.game : ~1 rows (environ)
INSERT INTO `game` (`id`, `dateTime`, `playerA_ID`, `playerB_ID`, `playerTurn`, `status`, `round`, `step`, `winnerID`) VALUES
	(1, '2024-07-15 09:29:57', 1, 2, 'A', 'active', 31, 'gen', NULL);

-- Listage de la structure de table splendor. g_card
DROP TABLE IF EXISTS `g_card`;
CREATE TABLE IF NOT EXISTS `g_card` (
  `gameID` int(11) unsigned DEFAULT NULL,
  `cardID` tinyint(4) unsigned DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  `slot` char(2) DEFAULT NULL,
  `rank` tinyint(3) unsigned DEFAULT NULL,
  KEY `idPartie` (`gameID`) USING BTREE,
  KEY `idCarte` (`cardID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Listage des données de la table splendor.g_card : ~70 rows (environ)
INSERT INTO `g_card` (`gameID`, `cardID`, `color`, `slot`, `rank`) VALUES
	(1, 1, '', 'X', 3),
	(1, 2, '', '', 17),
	(1, 3, '', '', 13),
	(1, 4, 'white', 'A', 2),
	(1, 5, 'neutral', '', 15),
	(1, 6, 'white', '', 11),
	(1, 7, 'white', 'A', 3),
	(1, 8, 'white', 'B', 1),
	(1, 9, 'white', '', 10),
	(1, 10, 'white', 'A', 1),
	(1, 11, 'blue', '', 9),
	(1, 12, 'blue', '', 7),
	(1, 13, 'blue', '', 8),
	(1, 14, 'blue', 'B', 1),
	(1, 15, 'blue', '', 16),
	(1, 16, 'black', '', 12),
	(1, 17, 'black', 'A', 2),
	(1, 18, 'black', 'A', 1),
	(1, 19, 'black', 'B', 2),
	(1, 20, 'black', 'B', 1),
	(1, 21, 'red', 'A', 1),
	(1, 22, 'red', 'X', 5),
	(1, 23, 'red', '', 14),
	(1, 24, 'red', 'X', 4),
	(1, 25, 'red', 'B', 1),
	(1, 26, 'green', 'A', 1),
	(1, 27, 'green', 'X', 2),
	(1, 28, 'green', '', 6),
	(1, 29, 'green', 'X', 1),
	(1, 30, 'green', 'A', 2),
	(1, 40, '', '', 13),
	(1, 41, '', '', 20),
	(1, 42, '', '', 21),
	(1, 43, 'neutral', '', 5),
	(1, 44, 'white', '', 12),
	(1, 45, 'white', '', 15),
	(1, 46, 'white', '', 10),
	(1, 47, 'white', 'Y', 1),
	(1, 48, 'blue', '', 17),
	(1, 49, 'blue', '', 11),
	(1, 50, 'blue', '', 18),
	(1, 51, 'blue', 'Y', 4),
	(1, 52, 'black', '', 16),
	(1, 53, 'black', '', 9),
	(1, 54, 'black', '', 6),
	(1, 55, 'black', 'Y', 2),
	(1, 56, 'red', 'Y', 3),
	(1, 57, 'red', '', 23),
	(1, 58, 'red', '', 19),
	(1, 59, 'red', '', 7),
	(1, 60, 'green', 'B', 1),
	(1, 61, 'green', '', 22),
	(1, 62, 'green', '', 8),
	(1, 63, 'green', '', 14),
	(1, 71, '', '', 13),
	(1, 72, 'neutral', 'Z', 1),
	(1, 73, 'white', 'Z', 3),
	(1, 74, 'white', '', 9),
	(1, 75, 'blue', '', 11),
	(1, 76, 'blue', '', 4),
	(1, 77, 'black', '', 10),
	(1, 78, 'black', '', 6),
	(1, 79, 'red', '', 7),
	(1, 80, 'red', 'Z', 2),
	(1, 81, 'green', '', 8),
	(1, 82, 'green', '', 12),
	(1, 101, 'neutral', 'R', 1),
	(1, 102, 'neutral', 'R', 2),
	(1, 103, 'neutral', 'R', 3),
	(1, 104, 'neutral', 'R', 4);

-- Listage de la structure de table splendor. g_privilege
DROP TABLE IF EXISTS `g_privilege`;
CREATE TABLE IF NOT EXISTS `g_privilege` (
  `gameID` int(11) DEFAULT NULL,
  `privilegeID` tinyint(4) DEFAULT NULL,
  `slot` char(2) DEFAULT NULL,
  `rank` tinyint(4) DEFAULT NULL,
  KEY `idPartie` (`gameID`) USING BTREE,
  KEY `idPrililège` (`privilegeID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Listage des données de la table splendor.g_privilege : ~3 rows (environ)
INSERT INTO `g_privilege` (`gameID`, `privilegeID`, `slot`, `rank`) VALUES
	(1, 1, 'P', 2),
	(1, 2, 'A', 1),
	(1, 3, 'P', 1);

-- Listage de la structure de table splendor. g_token
DROP TABLE IF EXISTS `g_token`;
CREATE TABLE IF NOT EXISTS `g_token` (
  `gameID` int(11) unsigned DEFAULT NULL,
  `tokenID` tinyint(4) unsigned DEFAULT NULL,
  `slot` char(2) DEFAULT NULL,
  `rank` tinyint(3) unsigned DEFAULT NULL,
  KEY `idPartie` (`gameID`) USING BTREE,
  KEY `idJeton` (`tokenID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Listage des données de la table splendor.g_token : ~25 rows (environ)
INSERT INTO `g_token` (`gameID`, `tokenID`, `slot`, `rank`) VALUES
	(1, 1, 'B', 1),
	(1, 2, 'C', 6),
	(1, 3, 'A', 1),
	(1, 4, 'C', 12),
	(1, 5, 'C', 19),
	(1, 6, 'C', 18),
	(1, 7, 'A', 1),
	(1, 8, 'A', 2),
	(1, 9, 'A', 1),
	(1, 10, 'C', 17),
	(1, 11, 'B', 1),
	(1, 12, 'C', 14),
	(1, 13, 'B', 1),
	(1, 14, 'B', 2),
	(1, 15, 'C', 16),
	(1, 16, 'C', 8),
	(1, 17, 'C', 3),
	(1, 18, 'C', 15),
	(1, 19, 'B', 1),
	(1, 20, 'C', 5),
	(1, 21, 'A', 1),
	(1, 22, 'B', 1),
	(1, 23, 'C', 7),
	(1, 24, 'C', 13),
	(1, 25, 'C', 10);

-- Listage de la structure de table splendor. player
DROP TABLE IF EXISTS `player`;
CREATE TABLE IF NOT EXISTS `player` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `login` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `gameCount` int(11) unsigned DEFAULT NULL,
  `score` int(11) unsigned DEFAULT NULL,
  `status` varchar(10) DEFAULT '',
  `gameID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gameID` (`gameID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Listage des données de la table splendor.player : ~4 rows (environ)
INSERT INTO `player` (`id`, `login`, `password`, `gameCount`, `score`, `status`, `gameID`) VALUES
	(1, 'Charlie', NULL, NULL, NULL, 'in game', 1),
	(2, 'Lulu', NULL, NULL, NULL, 'in game', 1),
	(3, 'Jules', NULL, NULL, NULL, '', 2),
	(4, 'Jim', NULL, NULL, NULL, '', 1);

-- Listage de la structure de table splendor. token
DROP TABLE IF EXISTS `token`;
CREATE TABLE IF NOT EXISTS `token` (
  `id` tinyint(4) unsigned NOT NULL,
  `color` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Listage des données de la table splendor.token : ~25 rows (environ)
INSERT INTO `token` (`id`, `color`) VALUES
	(1, 'white'),
	(2, 'white'),
	(3, 'white'),
	(4, 'white'),
	(5, 'blue'),
	(6, 'blue'),
	(7, 'blue'),
	(8, 'blue'),
	(9, 'black'),
	(10, 'black'),
	(11, 'black'),
	(12, 'black'),
	(13, 'red'),
	(14, 'red'),
	(15, 'red'),
	(16, 'red'),
	(17, 'green'),
	(18, 'green'),
	(19, 'green'),
	(20, 'green'),
	(21, 'pearl'),
	(22, 'pearl'),
	(23, 'gold'),
	(24, 'gold'),
	(25, 'gold');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
