const palettes    =[{'id':'light', 'css':'_palette_light.css'},{'id':'dark', 'css':'_palette_dark.css'}];
var stackFMessage =[{'msg':'Splendor Duel - Alpha', 'type':'info', 'TTL':-1, 'priority':1000, 'id':99}];
const traceLevel  = 0;

setInterval(refreshFMessage, 1000);

// Application de la palette
var paletteID = localStorage.getItem("palette");
if(!paletteID) { paletteID = palettes[0].id;}
// Chargement de la palette
loadCssFile(`../styles/${palettes.find(obj => obj.id==paletteID).css}`);

// Affichage de la palette sélectionnée
/*
if(paletteID==palettes[0].id) {
	document.querySelector(`#paletteSwitcher`).removeAttribute('checked');
} else {
	document.querySelector(`#paletteSwitcher`).setAttribute('checked', true);
}
*/
//document.querySelector(`#palette > option[value="${palette}"]`).setAttribute('selected', true);

// Application des variables de style
var style = localStorage.getItem("style");
if(!style) { style = 'default';}
// Chargement des variables de style
loadCssFile(`../styles/_variables_${style}.css`);
// Affichage du style sélectionnée
//document.querySelector(`#style > option[value="${style}"]`).setAttribute('selected', true);


function changePalette(newPaletteID) {
	// Lecture du Mode stocké dans le Storage Local
	const oldPaletteID = localStorage.getItem("palette");		
	if(palettes.find(obj => obj.id==newPaletteID)) {
		localStorage.setItem("palette", newPaletteID);	// Enregistrement du nouveau mode
		removeCssFile(`../styles/${palettes.find(obj => obj.id==oldPaletteID).css}`);	          // Supression de la palette actuelle
		loadCssFile(`../styles/${palettes.find(obj => obj.id==newPaletteID).css}`);	// Chargement du nouveau mode
	}
}

function changeStyle(newStyleID) {
	// Lecture du style stocké dans le Storage Local
	const oldStyleID = localStorage.getItem("style");				
	if (newStyleID) {
		localStorage.setItem("style", newStyleID);				// Enregistrement du nouveau style
		removeCssFile(`../styles/_variables_${oldStyleID}.css`);	// Supression des variable de style actuelle
		loadCssFile(`../styles/_variables_${newStyleID}.css`);	// Chargement des variable du nouveau style
	}
}

function toggleViewMode(elm) {
	if(elm.checked) {
		changePalette('dark');
	} else {
		changePalette('light');
	}
	
}

// Récupération du répertoire racine du site
var root = location.href.substring(0, location.href.lastIndexOf("/"));
root = root+"/";
//console.log(`Project root : ${root}`);

/*=========================================================
           NAVIGATION GENERALE
=========================================================*/
window.onload = (event) => {
	// Mémorisation de la page en cours pour la gestion du iFrame "index.html"
	var urlPage = window.location.pathname;
	splitUrl = urlPage.split("/");
	nomPage = splitUrl[splitUrl.length-1]
	sessionStorage.setItem("page", nomPage);
}

// Accès Accueil
function navWelcome() {
	var url = new URL(root+"welcome.php");
	document.location.href=url;
}
// Accès Salle d'attente
function navWaitingRoom() {
	var url = new URL(root+"waitingRoom.php");
	document.location.href=url;
}
// Accès Plateau de jeu
function navGameBoard() {
	var url = new URL(root+"gameBoard.php");
	document.location.href=url;
}

/*=========================================================
           GESTION DES COOKIES
=========================================================*/
// Lecture Cookie
function getCookie(nomCookie){
  if(document.cookie.length == 0)
    return null;

  var regSepCookie = new RegExp('(; )', 'g');
  var cookies = document.cookie.split(regSepCookie);

  for(var i = 0; i < cookies.length; i++){
    var regInfo = new RegExp('=', 'g');
    var infos = cookies[i].split(regInfo);
    if(infos[0] == nomCookie){
      return decodeURIComponent(infos[1]);
    }
  }
  return null;
}

// Ecriture Cookie
function setCookie(nomCookie, valeur) {
    document.cookie = nomCookie+"="+valeur+"; path=/; SameSite=Strict";
}

// Suppression Cookie
function deleteCookie(nomCookie) {
  // Mise à jour Cookie avec expiration antérieur
  document.cookie = nomCookie+"=; path=/; SameSite=Strict; expires=Thu, 01 Jan 1970 00:00:00 UTC";
}

/*=========================================================
           AUTRES FONCTIONS
=========================================================*/
// Encodage vers RFC3986
function encodeRFC3986URI(str) {
  return encodeURI(str)
    .replace(/%5B/g, "[")
    .replace(/%5D/g, "]")
    .replace(
      /[!'()*]/g,
      (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`,
    );
}

// Chargement dynamique d'une source CSS
function loadCssFile(fileName) {
	//console.log(`LoadCssFile ${fileName}`);
	// Chargement dynamique d'un fichier CSS
	var fileRef = document.createElement("link");
	fileRef.setAttribute("rel", "stylesheet");
	fileRef.setAttribute("type","text/css");
	fileRef.setAttribute("href",fileName);
	document.getElementsByTagName("head")[0].appendChild(fileRef);
 }
 // Suppression dynamique d'une source CSS
 function removeCssFile(fileName) {
	//console.log(`RemoveCssFile ${fileName}`);
	// Suppression dynamique d'un fichier CSS
	elmLink = document.querySelector(`link[href="${fileName}"]`);
	elmLink.parentNode.removeChild(elmLink);
 }

// Contrôle format IPV4
function isIPv4(address) {
  const ipv4Regex = /^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/;
  const matches = ipv4Regex.exec(address);
  
  if (!matches) {
    return false; // Ne correspond pas au format IPv4
  }

  // Vérifie que chaque partie de l'adresse est comprise entre 0 et 255
  for (let i = 1; i <= 4; i++) {
    if (parseInt(matches[i], 10) > 255 || parseInt(matches[i], 10) < 0) {
      return false; // Valeur en dehors de la plage valide
    }
  }

  return true; // Correspond au format IPv4
}

// Test si une chaine est interprétable en tant que JSON
function isJsonString(str) {
	try {
		JSON.parse(str);
	} catch (e) {
		return false;
	}
	return true;
}

// Mélange une table
function randomize(tab) {
	var i, j, tmp;
	for (i = tab.length - 1; i > 0; i--) {
		 j = Math.floor(Math.random() * (i + 1));
		 tmp = tab[i];
		 tab[i] = tab[j];
		 tab[j] = tmp;
	}
	return tab;
}

function trace(msg, level=1, error=false) {
	if(level<=traceLevel) {
		if(!error) {
			console.log(msg);
		} else {
			console.error(msg);
		}
	}
}

/*=========================================================
           GESTION DES MESSAGES PIED DE PAGE
=========================================================*/
// [{'msg':'Message', 'type':'info', 'TTL':-1, 'priority':10, 'id':999}];

function refreshFMessage() {
	const activeMsg = document.getElementById("footerMessage").innerText;
	if(stackFMessage.length>0) {
		stackFMessage.forEach(element => {
			if(element.TTL>0) element.TTL--;
		});
		// Tri de la stack message selon les priorité
		stackFMessage.sort(compareStackFMessage);
		// Supression des messages expirés
		stackFMessage = stackFMessage.filter(obj => obj.TTL !== 0);
	}
	var firstMsg = (stackFMessage.length>0)? stackFMessage[0].msg : '';
	if(firstMsg!=activeMsg) {
		// Affichage du message en haut de pile
		document.getElementById("footerMessage").innerText=firstMsg;
	}
}

function addFMessage(msg, type='info', TTL=-1, priority=100, id=0) {
	stackFMessage.push({'msg':msg, 'type':type, 'TTL':TTL, 'priority':priority, 'id':id});
	refreshFMessage();
}

function removeFMessage(critera) {
	varType = typeof critera;
	switch(varType) {
		case 'number':
			stackFMessage = stackFMessage.filter(obj => obj.id !== critera);
			break;
		case 'string':
			stackFMessage = stackFMessage.filter(obj => obj.msg !== critera);
			break;
	}
	refreshFMessage();
}
function compareStackFMessage(a, b) {
	return a.priority - b.priority;
}

/*=========================================================
           ACTION AU LANCEMENT
=========================================================*/
//changePalette('light');
//changeStyle('default');