/*=========================================================
           FONCTIONS DE TRI DES TABLES
=========================================================*/

// Demande de tri
function tSort(col_id, direction="ASC") {
	th = document.getElementById(col_id);																				// Identification de l'entête de tri
	if(!th){console.log(`!!! ID th '${col_id}'non trouvé`);}
	sort(th, direction);
}

// Demande de tri (clic sur th.tsort)
function sort(th, direction=null) {
	const headerLine = th.parentNode;															// Table des entêtes
	const elmHeader = headerLine.parentNode;
	const elmTable = elmHeader.parentNode;
	const table = elmTable.id;                											// Récupération du nom de la table à trier
	//if(!table){console.log('!!! data-set headerof non défini')}
	const column = Array.prototype.indexOf.call(headerLine.children, th);		// Identification du n° de colonne
	if(direction) {
		if(direction=="DESC") { asc=false; } else { asc=true; }						// Forçage du sens de tri
	} else {
		var asc = th.querySelector('span.sort').classList.contains('up');    	// Récupération du précédent sens de tri
		asc = !asc;                                                           	// Inversion du sens de tri
	}
	var thx = headerLine.querySelectorAll('th');											// Reset des indicateurs de tri des colonnes
	thx.forEach(thz => {                                                    
		up_down=thz.querySelector('span.sort')
		if(up_down) { up_down.classList='sort zMgL'; }
	})
	th.querySelector('span.sort').classList.add((asc)? "up" : "down");       	// Positionnement de l'indicateur
	setCookie(`${table}_SortColumn`, th.getAttribute('id'));
	setCookie(`${table}_SortDirection`, (asc)? "ASC" : "DESC");
	sortHtmlTable(table, column, asc);                                       	// Tri de la table
}

// Tri d'un tableau HTML selon la colonne et le sens indiqué
function sortHtmlTable(table, column, asc=true) {
	var elmTable = document.getElementById(table);	                          // Identification du tableau
	if(!elmTable){console.log(`!!! ID table '${table}'non trouvé`);}
	let tbodyElements = elmTable.tBodies;
	if(tbodyElements.length>0) {
		var tbody = tbodyElements[0];
	} else {
		console.error(`!!! Element tbody de la table id="${table}" introuvable`);
	}
	const trToSort = tbody.querySelectorAll('tr');                            // Collecte des lignes à trier
	const sortedCollection = Array.from(trToSort).sort(compare(column, asc)); // Tri selon la fonction 'compare' et l'ordre de tri 'asc'
	sortedCollection.forEach(tr => {                                          // Restitution des lignes triées
		tbody.appendChild(tr);
	});
	var postOp = tbody.dataset.sortpostop;
	if(postOp){window[postOp]();}
}

// Fonction de comparaison utilisée dans le tri des tables
const compare = function(ids, asc){
	return function(row1, row2){
   	const tdValue = function(row, ids){
   		return row.children[ids].textContent;
   	}
   	const tri = function(v1, v2){
   	if (v1 !== '' && v2 !== '' && !isNaN(v1) && !isNaN(v2)){ return v1 - v2; }
   	else { return v1.toString().localeCompare(v2); }
   	//return v1 !== '' && v2 !== '' && !isNaN(v1) && !isNaN(v2) ? v1 - v2 : v1.toString().localeCompare(v2);
   	};
   	return tri(tdValue(asc ? row1 : row2, ids), tdValue(asc ? row2 : row1, ids));
	}
}

// Création des indicateurs de tri pour les éléments th possédant la classe 'tsort'
function createSortingTag(titleSorted=null, asc=true) {
	// Encodage HTML du titre si existant
	if(titleSorted) {
   	const textArea = document.createElement("textArea");
   	textArea.innerHTML = titleSorted;
   	titleSorted = textArea.innerHTML;
	}
	// Collecte des éléments th avec l'attribut tsort
	var ths=document.querySelectorAll("th.tsort");
	// Parcours des éléments collectés
	ths.forEach(th => {
   	// Récupération et suppression du titre
      title = th.innerHTML;
      th.innerHTML="";
      // Création des éléments à ajouter
      div0 = document.createElement("div");
      div0.classList = "zFlexRow zHCenter";
      div1 = document.createElement("div");
      div1.classList = "zFlexRow zVCenter";
      span1 = document.createElement("span");
      span1.innerHTML = title;
      span2 = document.createElement("span");
      span2.classList = "sort zMgL";
      // Positionnement du tag (up ou down) sur le titre pré-trié
      if(title==titleSorted) { span2.classList.add((asc)? "up" : "down"); }
      // Ajout des éléments au document
      div1.appendChild(span1);
      div1.appendChild(span2);
      div0.appendChild(div1);
      th.appendChild(div0);
      // Ajout de la commande de tri
      th.setAttribute("onclick", "sort(this)");
	});
}

function updateLine(table, key, data) {
	var elmTable = document.getElementById(table);       // Identification du tableau
	// Sélection de la ligne définie par la clé 'key'
	if(elmTable) var tr = elmTable.querySelector(`tr[data-key="${key}"]`);
	 // Parcours des cellules de la ligne
	 if(tr) {
    	cells = tr.querySelectorAll('td');
    	cells.forEach(td => {
      	if(data[td.dataset.field]) td.textContent = data[td.dataset.field];
    	})
    	// Post-traitement
    	postProcessing(tr, data);
	}
}

function addLine(table, key, data) {
	//console.log(`addLine : table:${table} ${JSON.stringify(data)} key:${key}`);
	var elmTable = document.getElementById(table);      // Identification du tableau
	// Collecte des champs spécifiés dans l'entête
	const thf = elmTable.querySelectorAll('th');
	var tr = document.createElement('tr');
	tr.classList.add('alternateColor');
	tr.setAttribute('data-key', key);
	thf.forEach(th => {
		// Création de la cellule
		var td = document.createElement('td');
		if(th.dataset.align=='center') td.classList.add('tdCenter');
		td.setAttribute('data-field', th.dataset.field);
		td.textContent = data[th.dataset.field];
		tr.appendChild(td);
  	});
	// Ajout de la ligne dans le corps de la table
	document.querySelector(`#${table} tbody`).appendChild(tr);
	// Post-traitement
	postProcessing(tr, data);
}

function removeLine(table, key) {
	var elmTable = document.getElementById(table);      // Identification du tableau
	// Collecte des cellules ayant la classe td_%field
	if(elmTable) var tr = elmTable.querySelector(`tr[data-key="${key}"]`);
	// Suppression de la ligne du corps de la table
	if(tr) document.querySelector(`#${table} tbody`).removeChild(tr);
}

function postProcessing(elmTr, data) {
	const player = localStorage.getItem("login");
	// Mise en forme de la ligne
	const tdStatus = elmTr.querySelector(`td[data-field='status']`);
	const tdLogin = elmTr.querySelector(`td[data-field='login']`);
	const tdAction = elmTr.querySelector(`td[data-field='action']`);

	if(tdLogin.textContent==player) {
		elmTr.classList.remove('alternateColor');
		elmTr.classList.add('self');

		switch(tdStatus.textContent) {
			case 'available':
				tdStatus.innerHTML = `<div class="online">En ligne</div>`;
				break;
			case 'invited':
				tdStatus.innerHTML = `<div class="unavailable">Invité</div>`;
				break;
			case 'in game':
				tdStatus.innerHTML = `<div class="inGame">Partie en cours</div>`;
				break;
			case 'requested to play':
				tdStatus.innerHTML = `<div class="host">Vous invite à jouer</div>`;
				tdAction.innerHTML = `<button type="text" class="zMgR" onclick="accept('${tdLogin.textContent}')">Accepter</button><button type="text" onclick="deny('${tdLogin.textContent}')">Refuser</button>`;
			}			
		
	} else {

		switch(tdStatus.textContent) {
			case 'available':
				tdStatus.innerHTML = `<div class="available">Disponible</div>`;
				tdAction.innerHTML = `<button type="text" onclick="invite('${tdLogin.textContent}')">Inviter</button>`;
				break;
			case 'invited':
				tdStatus.innerHTML = `<div class="unavailable">Invité</div>`;
				tdAction.innerHTML = '';
				break;
			case 'in game':
				tdStatus.innerHTML = `<div class="inGame" data-gameID="${data.gameID}">Partie en cours</div>`;
				tdAction.innerHTML = '';
				break;
			case 'requested to play':
				tdStatus.innerHTML = `<div class="host">Vous invite à jouer</div>`;
				tdAction.innerHTML = `<button type="text" class="zMgL" onclick="accept('${tdLogin.textContent}')">Accepter</button><button type="text" class="zMgL" onclick="deny('${tdLogin.textContent}')">Refuser</button>`;
			}
		
	}

}