/*=========================================================
		GESTION DES POPUP/DIALOGUE
=========================================================*/

// 
// Ouverture fenêtre par ID
function openDialogByID(dialogID, modal=false) {
	console.log('> Demande ouverture Dialog '+dialogID);
	var elmDialog = document.querySelector(`dialog#${dialogID}`)
	console.log(elmDialog);
	if(modal) {
		elmDialog.showModal();
	} else {
		elmDialog.show();
	}
	// Centrage de la boite de dialogue dans la fenêtre navigateur
	elmDialog.style.left = (window.innerWidth-elmDialog.offsetWidth)/2+'px';
	elmDialog.style.top  = (window.innerHeight-elmDialog.offsetHeight)/2+'px';
}

// Fermeture fenêtre par ID
function closeDialogByID(dialogID) {
	var elmDialog = document.querySelector(`dialog#${dialogID}`)
	elmDialog.close()
}

function createDialog(ID, title, message, type='info', buttons=null, noSysClose=false) {
	// Construction Dialog
	var dialog = document.createElement("dialog");                  // Création de la boite de dialogue
	dialog.setAttribute('id', ID);
	dialog.classList.add(type);
	var divTitle = document.createElement('div');                   // Création de la la barre de Titre
	divTitle.setAttribute('id', 'dialog-titlebar');                 
	var spanTitle = document.createElement('span');                 // Création du texte du Titre
	spanTitle.classList.add('grow', 'mgr');
	spanTitle.innerHTML = title;
	divTitle.appendChild(spanTitle);                                // Ajout du texte dans la barre de Titre
	if(!noSysClose) {                                               
		var imgClose = document.createElement('img');                 // Création de l'image Bouton de Fermeture
		imgClose.classList.add('dialog');
		imgClose.setAttribute('src', '../images/checkbox_cross.png');
		imgClose.setAttribute('onclick', 'closeDialog()');
		divTitle.appendChild(imgClose);											// Ajout de l'image Bouton de Fermeture à la barre de Titre
	}
	dialog.appendChild(divTitle);													// Ajout de la barre de Titre à la boite de dialogue

	var divContainer = document.createElement('div');						// Création du Conteneur Générique
	divContainer.setAttribute('id', 'dialog-container');
	if(type=='alert') {
		divContainer.classList.add('alert');
		var imgAlert = document.createElement('img');
		imgAlert.setAttribute('src', '../images/report_problem.png');	// Création de l'image d'alerte
		imgAlert.classList.add('mgr');
		divContainer.appendChild(imgAlert);										// Ajout de l'image d'alerte au Conteneur Générique
	}
	var divMsg = document.createElement('div');								// Création de la div Message
	if(type=='alert') {
		divMsg.setAttribute('id', 'alert-msg');
	} else {
		divMsg.setAttribute('id', 'dialog-msg');
	}
	divMsg.innerHTML = message;
	divContainer.appendChild(divMsg);											// Ajout de la div Message au Conteneur Générique

	if(buttons){
		var divButton = document.createElement('div');						// Création de la div des boutons options
		divButton.setAttribute('id', 'dialog-zButtonImage');
		buttons.forEach(button => {
			zButtonImage = document.createElement('button');							// Création du bouton
			zButtonImage.classList.add('zButtonImage', 'mgl');
			zButtonImage.setAttribute('onclick', button['function']);
			img = document.createElement('img');								// Création de l'icone du bouton
			img.classList.add('zButtonImage-icon');
			img.setAttribute('src', `../images/${button['icon']}.png`)
			img.setAttribute('alt', `X`)
			zButtonImage.appendChild(img);
			img.after(button['lib']);
			divButton.appendChild(zButtonImage);											// Ajout du bouton à la div des boutons options
		})
		divContainer.appendChild(divButton);									// Ajout de la div Boutons options au Conteneur Générique
	}
	dialog.appendChild(divContainer);											// Ajout du Conteneur Générique à la boite de dialogue

	document.getElementById('innerview').appendChild(dialog);

}

// Fonction pour rendre la boîte de dialogue déplaçable
function makeDraggable(element) {
	const elementID = element.id;
	let deltaX = 0, deltaY = 0, prevX = 0, prevY = 0;

	const header = document.querySelector(`#${elementID} div.zDialogHeader`);
	const zButtonImageClose = document.querySelector(`#${elementID} img.zImgDialogClose`);

	header.addEventListener("mousedown", dragMouseDown);
	zButtonImageClose.addEventListener("click", closeDialog);

	function dragMouseDown(e) {
		e.preventDefault();
		prevX = e.clientX;
		prevY = e.clientY;
		document.addEventListener("mouseup", closeDragElement);
		document.addEventListener("mousemove", elementDrag);
	}

	function closeDialog() {
		console.log(">>> Fermeture de la fenêtre de dialogue");
		header.removeEventListener("mousedown",dragMouseDown);
		zButtonImageClose.removeEventListener("click", closeDialog);
		document.removeEventListener("mouseup", closeDragElement);
		document.removeEventListener("mousemove", elementDrag);
	}

	function elementDrag(e) {
	e.preventDefault();
	deltaX = prevX - e.clientX;
	deltaY = prevY - e.clientY;
	prevX = e.clientX;
	prevY = e.clientY;
	element.style.top = element.offsetTop - deltaY + "px";
	element.style.left = element.offsetLeft - deltaX + "px";
	}

	function closeDragElement() {
		document.removeEventListener("mouseup", closeDragElement);
		document.removeEventListener("mousemove", elementDrag);
	}

	function resetPosition() {
		var element = document.getElementById('editUtilisateur');
		element.style.left = '0px';
		element.style.top = '0px';
	}
}  