/* ===================================
		GESTION DES PRIVILEGES
	=================================== */
function givePrivilegeTo(tag) {
	trace(`Give Privilege to ${tag}`, 1)
   let privilegeGiven = {};
	// Privilèges disponible
	var availablePrivileges = game.privileges.filterBySlot('P');
	if(availablePrivileges.length>0) {
		availablePrivileges.sort((a,b) =>{ return a.rank-b.rank;});
		privilegeGiven = availablePrivileges.pop();
		game.privileges.findByID(privilegeGiven.privilegeID).moveToSlot(tag).report();
	} else {
		var otherTag = (tag=='A')? 'B' : 'A';
		var availablePrivileges = game.privileges.filterBySlot(otherTag);
		if(availablePrivileges.length>0) {
			availablePrivileges.sort((a,b) =>{ return a.rank-b.rank;});
			privilegeGiven = availablePrivileges.pop();
			game.privileges.findByID(privilegeGiven.privilegeID).moveToSlot(tag).report();
		}
	}
}

function restorePrivilege(tag) {
	trace(`Restore Privilege from ${tag} to stack`, 3)
	const availablePrivilege = game.privileges.filterBySlot(tag);
	if(availablePrivilege) {
		const privilege = availablePrivilege.pop();
		game.privileges.findByID(privilege.privilegeID).moveToSlot('P').report();
	}
}

/* ===================================
		PROTOTYPES
	=================================== */
// Objet: Liste de Privilèges
const privilegesPrototype = Object.create(Array.prototype);
privilegesPrototype.findByID = function(privilegeID) {
	privilegeID = parseInt(privilegeID);
	return this.find(privilege => privilege.privilegeID==privilegeID);
}
privilegesPrototype.filterBySlot = function(slot) {
	return this.filter(privilege => privilege.slot==slot);
}
privilegesPrototype.report = function() {
	parent.nodeSend(playerLogin, 'Update Data', {'privileges':this});
}

// Objet: Privilège
const privilegePrototype = {
	create: function() { 
		// Création du conteneur
		const container = document.createElement('div');
		container.id = 'P'+this.privilegeID;
		container.classList.add('privilege');
		// Création de l'image
		const img = document.createElement('img');
		img.classList.add('cardImage');
		img.setAttribute('src', `../images/scroll.png`);
		img.setAttribute('alt', `P${this.privilegeID}`);
		// Ajout de l'image dans la div
		container.appendChild(img);
		// Ajout dans la div 'void'
		document.getElementById('void').appendChild(container);
	},

	display: function() {
		const container = document.querySelector('#P'+this.privilegeID+'.privilege');
		container.parentNode.removeChild(container);
		if(this.slot=='P') var newSlot = document.getElementById(`M${this.rank}`);
		if(this.slot=='A') var newSlot = slotPlayerA('tokens', 'privilege');
		if(this.slot=='B') var newSlot = slotPlayerB('tokens', 'privilege');
		// Ajustement de la position dans le deck
		if(this.slot!='P') container.style.right=30*(this.rank-1)+'px'; else container.style.right=0;
		// Transfert dans le nouveau slot
		newSlot.appendChild(container);
	},

	moveToSlot: function(slot) {
		this.rank = game.privileges.filter(obj => obj.slot==slot).length+1;
		this.slot = slot;
		this.display();
		return this;
	},

	report: function() {
		parent.nodeSend(playerLogin, 'Update Data', {'privileges':[this]});
		return this;
	}

};