function submitLogin() {
	const login = document.getElementById('login').value;
	if(login) {
		localStorage.setItem("login", login);
		parent.nodeSend(login, 'login');
	}
}

function messageProcessing(event) {
	console.log(`> Réception données: ${event.data}`);
	if(isJsonString(event.data)) {
		//console.log(' ... Message JSON valide');
		const message = JSON.parse(event.data);
		const emetteur = message.from.toLowerCase();
		if(emetteur=='node') {
			const notification = message.notif;
			switch(notification.toLowerCase()) {
				case "welcome":
					navWaitingRoom();
					break;
				case 'players online':
					break;
				case 'add player':
					break;
				case 'remove player':
					break;
				case 'update player':
					break;
				case 'requested to play with':
					break;
				case 'request reject from':
					break;
				case 'resume game':
					break;
				case 'game ready':
					break;
				default:
					unknownMessage  = `!!! Réception d'un message inconnu)\n`;
					unknownMessage += ` Notification : ${notification}\n`;
					if(message.data) unknownMessage += ` Données : ${JSON.stringify(message.data)}`;
					console.error(unknownMessage);
			}
		}
	} else {
		console.error(`Message "${event.data}" non traité`);
	}
}

