<!DOCTYPE html>
<html lang="fr">
	<head>
		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
  
		<title>Splendor Duel</title>
		<link rel="icon" href="../favicon.ico" />

		<?php $t = time() ?>

		<style type="text/css">
			@import "../styles/_common.css?<?php echo $t ?>";
			@import "../styles/_objects.css?<?php echo $t ?>";
			@import "../styles/gameBoard.css?<?php echo $t ?>";
		</style>
        
	</head>

	<body class="zFlexRow">
		<!-- BANNIERE LATERALE -->
		<div id="banner">
			<img class="logo" src="../images/banner.png" alt="logo">
			<div id="gameData" class="zFlexCol">
				<span id="gameID">Partie : </span>
				<div class="zFlexRow"><span>Joueur A :&nbsp;</span><span id="loginA"></span></div>
				<div class="zFlexRow"><span>Joueur B :&nbsp;</span><span id="loginB"></span></div>
				<span id="playerRound"></span>
				<span id="message"></span>
			</div>
			<div id="options" class="zFlexCol hidden">
				<button id="usePrivilege" class="zButton zButtonTextStd zMgT uact" onclick="usePrivilege()">Utiliser un privilège</button>
				<button id="reloadToken" class="zButton zButtonTextStd zMgT uact" onclick="reloadToken()">Recharge les jetons</button>
				<button id="pickToken" class="zButton zButtonTextStd zMgT uact" onclick="pickToken()">Prendre des jetons</button>
				<button id="reserveCard" class="zButton zButtonTextStd zMgT uact" onclick="reserveCard()">Réserver une carte</button>
				<button id="buyCard" class="zButton zButtonTextStd zMgT uact" onclick="buyCard()">Acheter une carte</button>
				<button id="cancelAction" class="zButton zButtonTextStd hidden">Annuler l'action en cours</button>
			</div>
			<div class="zFlexCol zVCenter zMgT">
				<div id="win">
					<div id="globalPrestige" class="wReport zMgL"></div>
					<div id="crowns" class="wReport"></div>
					<div id="coloredPrestige" class="wReport zMgR"></div>
				</div>
				<img id="wb" src="../images/win.png" alt="win">
			</div>
			<div class="zFlexCol zFGrow">
				<!--
				<button id="selCard" class="zMgT" onclick="victory()">Test Victory</button>
				-->
			</div>
			<span id="footerMessage" class="zCommentStyle"></span>
		</div>
		<!-- ZONE DE JEU -->
		<div id="z_innerview">
			<div id="void" class="hidden"></div>

			<div id="boards">
				<!-- PLATEAU DE JETONS -->
				<div id="tokenBoard">
					<div class="zFlexRow">
						<div id="boardCmd" class="zFlexRow zVCenter"></div>
						<div id="tokenReserve" class="tokenBoardSlot hidden"></div>
					</div>
					<?php
					$grid=[["S17","S18","S19","S20","S21"],["S16","S5","S6","S7","S22"],["S15","S4","S1","S8","S23"],["S14","S3","S2","S9","S24"],["S13","S12","S11","S10","S25"]];
					for($i=0; $i<=4; $i++) { ?>
						<div id="line" class="zFlexRow">
					<?php
						for($j=0; $j<=4; $j++) { ?>
							<div id="<?php echo $grid[$i][$j]; ?>" data-coord="<?php echo $i.'.'.$j; ?>" class="tokenBoardSlot"></div>
						<?php
						} ?>
						</div>
					<?php
					} ?>
				</div>

				<!-- PLATEAU DES CARTES -->
				<div id="cardBoard">
				<?php
				$nCards=3;
				$slot = ["X", "Y", "Z"];
				for($i=3; $i>=1; $i--) { ?>
					<div id="level<?php echo $i; ?>" class="zFlexRow">
					<div id="stackLevel<?php echo $i; ?>" class="cardBoardSlot"></div>
					<?php
					for($j=1; $j<=$nCards; $j++) { ?>
						<div id="<?php echo $slot[$i-1].$j; ?>" class="cardBoardSlot" data-slot="<?php echo $slot[$i-1];?>" data-rank="<?php echo $j;?>"></div>
					<?php
					} ?>
					</div>
				<?php
				$nCards++;
				} ?>
				</div>
			
				<!-- PLATEAU DES PRIVILEGES ET DES CARTES ROYALES -->
				<div id="stuff">
					<div class="zFlexRow">
						<div id="M1" class="privilegeBoardSlot"></div>
						<div id="M2" class="privilegeBoardSlot"></div>
						<div id="M3" class="privilegeBoardSlot"></div>
					</div>

					<div class="zFlexRow">
						<div id="R1" class="cardBoardSlot"></div>
						<div id="R2" class="cardBoardSlot"></div>
					</div>
					<div class="zFlexRow">
						<div id="R3" class="cardBoardSlot"></div>
						<div id="R4" class="cardBoardSlot"></div>
					</div>
				</div>

			</div>

			<div id="playersBoard">
				<div id="myDeck" class="deck">
					<div id="tokens" class="zFlexRow">
						<div id="gold" class="tokenPlayerSlot"></div>
						<div id="white" class="tokenPlayerSlot"></div>
						<div id="blue" class="tokenPlayerSlot"></div>
						<div id="green" class="tokenPlayerSlot"></div>
						<div id="red" class="tokenPlayerSlot"></div>
						<div id="black" class="tokenPlayerSlot"></div>
						<div id="pearl" class="tokenPlayerSlot"></div>
						<div id="privilege" class="privilegePlayerSlot"></div>
					</div>
					<div id="cards" class="zFlexRow">
						<div id="white" class="cardPlayerSlot"></div>
						<div id="blue" class="cardPlayerSlot"></div>
						<div id="green" class="cardPlayerSlot"></div>
						<div id="red" class="cardPlayerSlot"></div>
						<div id="black" class="cardPlayerSlot"></div>
						<div id="neutral" class="cardPlayerSlot"></div>
						<div id="reserve" class="cardPlayerSlot zMgL"></div>
					</div>
				</div>

				<div id="opponentDeck" class="deck">
					<div id="tokens" class="zFlexRow">
						<div id="gold" class="tokenPlayerSlot"></div>
						<div id="white" class="tokenPlayerSlot"></div>
						<div id="blue" class="tokenPlayerSlot"></div>
						<div id="green" class="tokenPlayerSlot"></div>
						<div id="red" class="tokenPlayerSlot"></div>
						<div id="black" class="tokenPlayerSlot"></div>
						<div id="pearl" class="tokenPlayerSlot"></div>
						<div id="privilege" class="privilegePlayerSlot"></div>
					</div>
					<div id="cards" class="zFlexRow">
						<div id="white" class="cardPlayerSlot"></div>
						<div id="blue" class="cardPlayerSlot"></div>
						<div id="green" class="cardPlayerSlot"></div>
						<div id="red" class="cardPlayerSlot"></div>
						<div id="black" class="cardPlayerSlot"></div>
						<div id="neutral" class="cardPlayerSlot"></div>
						<div id="reserve" class="cardPlayerSlot zMgL"></div>
					</div>
				</div>
			</div>

		</div>
		
		<div id="snackbar"></div>
		<!-- PIED DE PAGE -->
		<footer id="z_footer">
		</footer>

	</body>

	<script src="../js/_common.js?<?php echo $t ?>"></script>
	<script src="../js/card.js?<?php echo $t ?>"></script>
	<script src="../js/token.js?<?php echo $t ?>"></script>
	<script src="../js/privilege.js?<?php echo $t ?>"></script>
	<script src="../js/gameBoard.js?<?php echo $t ?>"></script>

</html>