<!DOCTYPE html>
<html lang="fr">
	<head>
		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
  
		<title>Splendor Duel</title>
		<link rel="icon" href="../favicon.ico" />

		<?php $t = time() ?>

		<style type="text/css">
			@import "../styles/_common.css?<?php echo $t ?>";
			@import "../styles/_objects.css?<?php echo $t ?>";
			@import "../styles/_dataTable.css?<?php echo $t ?>";
			@import "../styles/waitingRoom.css?<?php echo $t ?>";
		</style>
        
	</head>

	<?php
		// Inclusiion des fonctions communes et/ou spécifiques
		include "../php/_common.php";
		include "../php/_dataTable.php";
	?>	

	<script src="../js/_common.js?<?php echo $t ?>"></script>
	<script src="../js/_dialog.js?<?php echo $t ?>"></script>
	<script src="../js/_dataTable.js?<?php echo $t ?>"></script>
	<script src="../js/waitingRoom.js?<?php echo $t ?>"></script>

	<body>
		<!-- ENTETE DE PAGE -->
		<header id="z_header">
			<img class="logo" src="../images/Logo.png" alt="logo">
		</header>

		<!-- CORPS DE PAGE -->
		<div id="z_innerview">
			<div class="zDataBlock">
				<div class="table-container">
					<table id="players" class="tableCompact">
						<?php
							buildDataTable("players");
						?>
					</table>
					<script>createSortingTag(); </script>
				</div>
			</div>
		</div>
		
		<!-- PIED DE PAGE -->
		<footer id="z_footer">
			<span id="footerMessage" class="zCommentStyle"></span>
		</footer>

	</body>

</html>