<?php

// POUR TESTS
// Détermine si exécution sous navigateur (CGI) ou directement en PHP
$HTTP_HOST = filter_input(INPUT_SERVER, 'HTTP_HOST');
if(!$HTTP_HOST) {
	define("CLI", true);
	define("CGI", false);
	define("RC", "\n");
} else {
	define("CLI", false);
	define("CGI", true);
	define("RC", "<br>");
}

// Racine du projet
$projectRoot = str_replace("\\", "/", dirname(__FILE__, 2));
trace("- projectRoot : $projectRoot");

// Lecture des paramètres
$paramFile = "$projectRoot/php/secure/parametres.xml";
if (file_exists($paramFile)) {
	trace("> Chargement des paramètres d'application depuis le fichier XML");
	$param = simplexml_load_file($paramFile);
} else {
	trace('!!! Fichier de paramètres absent.');
}


/* =============================================================================
   FONCTIONS GESTION DB
 =============================================================================*/
// Ouverture de la DB
//trace("> Ouverture de la DB ".$param->DB->dsn);
//$dataBase = openDB($param->DB->dsn, $param->DB->user, $param->DB->password);
//if(!$dataBase) {trace("!!! Pb à l'ouverture de la DB");}

// Fonctions de de gestion DB
function openDB($dsn, $user, $pwd) {
	//On essaie de se connecter
	try{
		$conn = new PDO($dsn, $user, $pwd);
		//On définit le mode d'erreur de PDO sur Exception
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		//echo 'Connexion réussie';
		return $conn;
	}
					
	/*On capture les exceptions si une exception est lancée et on affiche
	*les informations relatives à celle-ci*/
	catch(PDOException $e){
		//echo "Erreur : " . $e->getMessage();
		return null;
	}
}

function ExecuteRequete($request, $conn) {
	// Identification de la commande
	$dummy = explode(" ",strtoupper($request));
	$command = $dummy[0];
	trace("Requête à exécuter : $request");

	// Préparation et exécution de la requête
	$DBRequest = $conn->prepare($request);
	$DBRequest->execute();

	// Collecte du résultat
	switch($command) {
		case "SELECT":
			$queryResult = $DBRequest->FetchAll();
			break;
		case "INSERT" || "UPDATE":
			$DBQuery = $conn->prepare('SELECT @@IDENTITY');
			$DBQuery->execute();
			$queryResult = $DBQuery->FetchAll();
			break;
		default:
		$queryResult = null;
	}
	return $queryResult;
}

function toSqlFormat($textValue) {
	$textValue = str_replace("'", "\'", $textValue);
	$textValue = str_replace('"', '\"', $textValue);
	return $textValue;
}

/* =============================================================================
   AUTRES FONCTIONS
	=============================================================================*/

// Lecture de Cookie
function getCookie($cookieName, $default="") {
	if(isset($_COOKIE[$cookieName])) {
		 return $_COOKIE[$cookieName];
	} else {
		 return $default;
	}
}

// Trace lors des exécutions en mode client
function trace($message) {
	if(CLI) { echo $message.PHP_EOL; }
}